	program MAIN
! -----------------------------------------------------------------
!	2D FEM
! -----------------------------------------------------------------
	implicit none
	integer Ne, Nn, Nb, Nm, Np, Nd, Ng, Ns, NnNd	! array parameters
	integer iout, idbg, ipost
	integer lastA, lastL, lastB, lastQc1, lastQd1, lastF1, lastQc2, lastQd2, lastF2
	integer lastY, lastZ
	integer Nt, n
	integer ldw, maxit
	real*8 Sx, Kappa, tc, aopt, por
	real*8 time, tmax, dt, dto, timeo
	real*8 theta, theta1, Ctol
	integer ipar(16), ipar0(16)			! bCGstab integer parameters array
	real*8 fpar(16), fpar0(16)			! bCGstab real    parameters array
	real*8 Ae(4,4), Le(4,4), Be(4,4)		! element arrays
	real*8 Qce1(4,4), Qde1(4,4)			! element arrays
	real*8 Qce2(4,4), Qde2(4,4)			! element arrays
	integer, allocatable :: rA (:), rL (:), rB (:)	! global  arrays (compact rows)
	integer, allocatable :: cA (:), cL (:), cB (:)	! global  arrays (compact columns)
	integer, allocatable :: rY (:), cY (:)		! global  arrays
	integer, allocatable :: rZ (:), cZ (:)		! global  arrays
	integer, allocatable :: rQc1(:), rQd1(:), rF1 (:)	! global  arrays (compact rows)
	integer, allocatable :: rQc2(:), rQd2(:), rF2 (:)	! global  arrays (compact rows)
	integer, allocatable :: cQc1(:), cQd1(:), cF1 (:)	! global  arrays (compact columns)
	integer, allocatable :: cQc2(:), cQd2(:), cF2 (:)	! global  arrays (compact columns)
	integer, allocatable :: ie(:,:)			! global connectivity array
	integer, allocatable :: nmat(:,:)		! global nodal materials array
	integer, allocatable :: BCe(:,:), BCi(:)	! BC element and local element
						 	! face numbers
	real*8, allocatable :: BCn(:,:)			! BC N's
	real*8, allocatable :: BCvalue(:,:,:)		! BC value (j_bar, q_bar or c_bar)
	character*1, allocatable ::  BCtype(:)		! BC type ('R', 'N' or 'D')
	real*8, allocatable :: x(:,:)			! global coordinates array
	real*8, allocatable :: C   (:,:), T   (:,:)	! global  arrays
	real*8, allocatable :: Cold(:,:), Told(:,:) 	! global  arrays
	real*8, allocatable :: Cit (:,:)		! global  arrays
	real*8, allocatable :: Son (:,:), Soe(:,:,:)	! global  arrays
	real*8, allocatable :: phi (:), phio(:)		! global  arrays
	real*8, allocatable :: vA (:), vL (:), vB (:)	! global  arrays (compact values)
	real*8, allocatable :: vY (:), vZ(:)		! global  arrays (compact values)
	real*8, allocatable :: vQc1(:), vQd1(:), vF1(:)	! global  arrays (compact values)
	real*8, allocatable :: vQc2(:), vQd2(:), vF2(:)	! global  arrays (compact values)
	real*8, allocatable :: V(:,:), D(:,:,:)		! global  arrays
	real*8, allocatable :: Rn(:,:), w(:,:), work(:)	! work arrays
	real*8, allocatable :: M1(:,:)			! Mp(dt) for term p
	real*8, allocatable :: par(:,:,:)		! M(t) parameters
	real*8, allocatable :: In(:,:,:), Kn(:,:,:)	! convolution arrays for M*C
	real*8, allocatable :: Iyn(:,:), Kyn(:,:)	! convolution arrays for M*phi
	real*8, allocatable :: xg(:), wg(:)		! Gauss abscissas [-1,+1] and weights
	real*8, allocatable :: J(:,:,:,:), Ji(:,:,:,:), Jac(:,:), Jaci(:,:)
							! geometric entities
	real*8, allocatable :: Shp(:,:,:), dNdr(:,:,:,:), Wgt(:,:,:)
							! shape and weight functions
	real*8, allocatable :: Jib(:,:,:,:), a33(:)		! boundary geometric entities
	real*8, allocatable :: Shpb(:,:,:), dNdrb(:,:,:,:)	! boundary shape functions
	real*8, allocatable :: Ao(:), Vm(:,:)			! nodal averaged array
	real*8, allocatable :: gm0(:,:), gm1(:,:), m1s(:,:)	! nodal averaged arrays
	real	 time_begin, time_end

	integer Nr					! ### new parameters ###
	integer, allocatable :: order(:,:)		! ### new parameters ###
	real*8, allocatable ::  Rr(:,:)			! ### new parameters ###

	integer e, Nc, i, s, it
	real*8 Cerr, Cerrmax

	data iout/3/, idbg/2/, ipost/4/
	data n/0/, time/0./, Nc/0/

	call CPU_TIME ( time_begin )

! open files
	open(iout, file='fout.txt', status='unknown')
	open(idbg, file='fdbg.txt', status='unknown')
	open(ipost,file='post.msh', status='unknown')

	write(idbg,'(a)') ' --- MAIN ---'	! ### TEMPORARY ###
	write(iout,*) '**********************************'	! version ID
	write(iout,*) '2D FEM v54.4 of 10/10/18'		! version ID
	write(iout,*) '**********************************'	! version ID

! read parameters
	call READPARAM(iout, idbg, Ne, Nn, Nb, Nm, Np, Nd, Ng, Ns)

! allocate arrays
	ldw  = 8*Nn	! storage for SPARSKIT BCGSTAB
	NnNd = 9*Nn	! 9 entries for 2D elements
	write(iout,*) 'ldw = ', ldw
	allocate ( ie(Ne,5), x(Nn,2), C(Nn,Ns), T(Nn,Ns), Cold(Nn,Ns), Told(Nn,Ns) )
	allocate ( Soe(Ne,Ns,4), Son(Nn,Ns) )
	allocate ( Vm(Nn,2), Cit(Nn,Ns) )
	allocate ( vA (NnNd ), vL (NnNd ), vB(NnNd ), vZ(NnNd ) )
	allocate ( rA (Nn+1) , rL (Nn+1) , rB(Nn+1) , rZ(Nn+1) )
	allocate ( cA (NnNd) , cL (NnNd) , cB(NnNd) , cZ(NnNd) )
	allocate ( vQc1(NnNd), vQd1(NnNd), vF1(NnNd) )
	allocate ( vQc2(NnNd), vQd2(NnNd), vF2(NnNd) )
	allocate ( rQc1(Nn+1), rQd1(Nn+1), rF1(Nn+1) )
	allocate ( rQc2(Nn+1), rQd2(Nn+1), rF2(Nn+1) )
	allocate ( cQc1(NnNd), cQd1(NnNd), cF1(NnNd) )
	allocate ( cQc2(NnNd), cQd2(NnNd), cF2(NnNd) )
	allocate ( V(Ne,2), D(Ne,2,2), nmat(Nn,0:Nd) )
	allocate ( Rn(Nn,Ns), w(Nn,Ns), work(ldw) )
	allocate ( xg(Ng), wg(Ng), J(2,2,Ng,Ng), Ji(2,2,Ng,Ng), Jac(Ng,Ng), Jaci(Ng,Ng) )
	allocate ( Shp(4,Ng,Ng), dNdr(4,2,Ng,Ng), Wgt(4,Ng,Ng)  )
	allocate ( Jib(2,2,Nb,Ng), a33(Nb), Shpb(2,Nb,Ng), dNdrb(2,2,Nb,Ng) )
	allocate ( BCe(Nb,3), BCi(Nb), BCn(Nb,2), BCvalue(Nb,Ns,2), BCtype(Nb) )
	allocate (order(Nn,0:1), Rr(Nn,Ns) )		! ### new parameters ###

	if(Np .ne. 0) then
! EXP arrays allocation
	  allocate ( M1(0:Np,Nm), par(0:Np,2,Nm), In(Nn,Ns,0:Np), Kn(Nn,Ns,Np) )
	  allocate ( gm0(Nn,Np), gm1(Nn,Np), m1s(Nn,Np), Ao(Nn) )
	endif

! read input
	call READIN(iout, idbg, ipost, Ne, Nn, Nb, Nm, Np, Ng, Ns, NnNd, ldw, &
			Sx, Kappa, tc, aopt, tmax, dt, dto, Nt, theta, theta1, ie, &
			x, C, V, D, par, xg, wg, BCe, BCi, BCvalue, BCtype, Soe, por, &
			vA, vL, vB, vQc1, vQd1, vF1, vQc2, vQd2, vF2, ipar, fpar, maxit, Ctol, &
			rA, rL, rB, rQc1, rQd1, rF1, rQc2, rQd2, rF2, &
			cA, cL, cB, cQc1, cQd1, cF1, cQc2, cQd2, cF2, &
			lastA, lastL, lastB, lastQc1, lastQd1, lastF1, lastQc2, lastQd2, lastF2)

	if(Kappa .ne. 0.) then
! arrays allocation for reactive transpost
	  allocate ( phi(Nn), vY (NnNd ), rY (Nn+1), cY (NnNd) )
	  if(Np .ne. 0) then
! EXP arrays allocation for reactive transpost
	    allocate ( phio(Nn), Iyn(Nn,0:Np), Kyn(Nn,Np) )
	  endif
	endif

! Build a matrix of materials at each node
	call NODALMAT(iout, idbg, Ne, Nn, Nd, ie, nmat)

	ipar0 = ipar	! store the original ipar
	fpar0 = fpar	! store the original fpar

! loop on elements
	do e = 1, Ne

! calculate element shape functions
	  call SHAPE(iout, idbg, Ne, Nn, Ng, V, ie, x, xg, e, &
			  Shp, dNdr, Wgt, J, Jac, Ji, Jaci, aopt)
! calculate element matrices
	  call SHAPEM(iout, idbg, Ne, Ng, Sx, V, D, &
			 Ae, Le, Be, wg, e, Shp, dNdr, Wgt, Jac, Ji)

! calculate nodal flux matrices
	  call SHAPEQ(iout, idbg, Ne, Nn, V, D, Qce1, Qde1, Qce2, Qde2, &
			 ie, x, e)

! assemble arrays
	  call ASSEMBLE(iout, idbg, Ne, Nn, Nd, NnNd, &
			vA, vL, vB, vQc1, vQd1, vQc2, vQd2, &
			rA, rL, rB, rQc1, rQd1, rQc2, rQd2, &
			cA, cL, cB, cQc1, cQd1, cQc2, cQd2, &
			lastA, lastL, lastB, lastQc1, lastQd1, lastQc2, lastQd2, &
			Ae, Le, Be, Qce1, Qde1, Qce2, Qde2, ie, nmat, e)

	enddo	! e

	if(Np .ne. 0)	then
! calculate the memory function, M(t), for EXP, at t=dt
	  call MT(iout, idbg, Nm, Np, dt, par, M1)
	endif

! initialize
	call INIT(iout, idbg, Ne, Nn, Nb, Nm, Np, Nd, Ns, NnNd, dt, &
			theta, theta1, BCe, BCi, BCn, BCvalue, BCtype, ie, x, nmat, &
			C, T, Cold, Told, M1, par, In, Iyn, Kappa, tc, &
			vA, vL, vB, vQc1, vQd1, vF1, vQc2, vQd2, vF2, vY, vZ, &
			rA, rL, rB, rQc1, rQd1, rF1, rQc2, rQd2, rF2, rY, rZ, &
			cA, cL, cB, cQc1, cQd1, cF1, cQc2, cQd2, cF2, cY, cZ, &
			lastA, lastL, lastB, lastY, lastZ, lastQc1, lastQd1, lastF1, &
			lastQc2, lastQd2, lastF2, V, Vm, Ao, gm0, gm1, m1s, &
			phi, phio, &
			Nr, order, Rr)		! ### new parameters ###

! calculate the independent source [A]{So} (time-independent)
	call SOURCE0(iout, idbg, Ne, Nn, Np, Ns, NnNd, ie, tc, Soe, &
			 vZ, rZ, cZ, lastZ, Son)
	deallocate (Soe, vZ, rZ, cZ)

! calculate element shape functions on boundary faces
	call SHAPEB(iout, idbg, Ne, Nn, Nb, Ng, Sx, BCe, Bci, ie, x, xg, &
			  Jib, a33, Shpb, dNdrb)

! write solver output, C, T and nodal fluxes
	call OUT(iout, idbg, ipost, Nn, Np, Ns, NnNd, ldw, &
			time, Nc, C, T, w, work, In, Ao, &
			lastQc1, lastQd1, lastF1, lastQc2, lastQd2, lastF2, &
			vQc1, vQd1, vF1, rQc1, rQd1, rF1, cQc1, cQd1, cF1, &	
			vQc2, vQd2, vF2, rQc2, rQd2, rF2, cQc2, cQd2, cF2)	
	timeo = dto

	call CPU_TIME ( time_end )
	write (iout,*) 'Initialization time=', time_end - time_begin, ' seconds'

! time loop
	do n = 1, Nt

! advance in time
	  time = time + dt

! implicit BC and source iteration loop
	  do it = 1, maxit
	    Cit = C	! save former iteration C
! update BC
	    call BC(iout, idbg, Nn, Nb, Np, Ng, Ns, BCe, BCn, BCvalue, BCtype, &
			C, T, Son, In, Ao, Vm, wg, Jib, a33, Shpb, dNdrb)

	    if (Kappa .gt. 0.)	then
! update reaction source
	      call SOURCE(iout, idbg, Nn, Np, Ns, NnNd, &
			vY, rY, cY, lastY, Kappa, T, phi, Iyn)
	    endif

! solve equations and update
	    call SOLVE(iout, idbg, Nn, Nb, Np, Ns, NnNd, ldw, &
			Kappa, theta, theta1, ipar, fpar, ipar0, fpar0, &
			BCe, BCvalue, BCtype, C, T, Cold, Told, Rn, &
			vA, vL, vB, rA, rL, rB, cA, cL, cB, lastA, lastL, lastB, &
			In, Kn, Ao, gm0, gm1, m1s, phi, phio, &
			Iyn, Kyn, w, work, &
			Nr, order, Rr)		! ### new parameters ###

! check iteration convegence
	    Cerrmax = 0.	! initialize C error
	    do i = 1, Nn
	      do s = 1, Ns
		Cerr = abs(C(i,s)-Cit(i,s))
		if(Cerr .gt. Cerrmax)	Cerrmax = Cerr
	      enddo	! s
	    enddo	! i
	    if(Cerrmax .le. Ctol)	exit
	  enddo		! it
	  if(it .gt. maxit)	then
	    write(iout,*) '*** ABORT: BC/source converge failure. it, Cerrmax = ', &
		 it, Cerrmax
	    stop
	  endif

	  if( abs(time - timeo) .le. 0.5*dt ) then
! write solver output, C, T and nodal fluxes
	    call OUT(iout, idbg, ipost, Nn, Np, Ns, NnNd, ldw, &
			time, Nc, C, T, w, work, In, Ao, &
			lastQc1, lastQd1, lastF1, lastQc2, lastQd2, lastF2, &
			vQc1, vQd1, vF1, rQc1, rQd1, rF1, cQc1, cQd1, cF1, &	
			vQc2, vQd2, vF2, rQc2, rQd2, rF2, cQc2, cQd2, cF2)	
	    timeo = time + dto
	  endif

! update Cold and Told for the next step
	  Cold = C				! use matrix form
	  Told = T				! use matrix form
	  if(Np.ne.0 .and. Kappa.ne.0.) then
! for reactive EXP only reset phi of the former time step, phio, to phi
	    phio= phi	! use matrix form
	  endif
	enddo	! n

	call CPU_TIME ( time_end )
	write (iout,*) 'Total time=', time_end - time_begin, ' seconds'
	end
